function varargout = ModelFitGUI(varargin)

%------------------------------------------------------------------------%
% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @ModelFitGUI_OpeningFcn, ...
                   'gui_OutputFcn',  @ModelFitGUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end

% End initialization code - DO NOT EDIT

% Executes just before ModelFitGUI is made visible.
function ModelFitGUI_OpeningFcn(hObject, ~, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to ModelFitGUI (see VARARGIN)

% Choose default command line output for ModelFitGUI
handles.output = hObject;
handles.savepath = 'PATH-TO-OUTPUT';
handles.modelcols = 'br';

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes ModelFitGUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% Outputs from this function are returned to the command line.
function varargout = ModelFitGUI_OutputFcn(hObject, ~, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


%------------------------------------------------------------------------%
% Object Creation

function listbox_mouse_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','red');
end

function listbox_chan_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function listbox_model_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit_p1_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit_p2_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit_p3_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit_p4_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit_p5_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit_p6_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%------------------------------------------------------------------------%
% Object Callback

% List: Mice
function listbox_mouse_Callback(hObject, ~, handles)
i = hObject.Value;
mouse = hObject.String{i};

switch mouse
	case 'Ba' 
    	channels = {[1:12,0,-1]};
	case 'Le'
    	channels = {[1:16,0,-1]};
	case 'Ni'
    	channels = {[1:12,0,-1]};
	case 'No'
    	channels = {[1:10,0,-1]};
	case 'Th'
    	channels = {[1:12,0,-1]}; 
    case 'Za'
    	channels = {[1:16,0,-1]}; 
end

handles.model.mouse = mouse;
handles.listbox_chan.String = channels;
handles.listbox_chan.Enable = 'on';
guidata(hObject,handles)

% List: Channels
function listbox_chan_Callback(hObject, ~, handles)
i = hObject.Value;
chan = str2num(hObject.String{i});
handles.model.chan = chan;
handles.pushbutton_load.Enable = 'on';
guidata(hObject,handles)

% List: Models
function listbox_model_Callback(hObject, ~, handles)
modelType = hObject.Value;
handles.model.type = modelType;

handles.pushbutton_loadparms.Enable = 'on';
handles.pushbutton_default.Enable = 'on';
handles.pushbutton_optimise.Enable = 'on';
handles.pushbutton_save.Enable = 'on';
handles.pushbutton_savefig.Enable = 'on';
handles.pushbutton_resetplot.Enable = 'on';

guidata(hObject,handles)


% Button: Load Data for SWA model
function pushbutton_load_Callback(hObject, ~, handles)
busyLightOn(hObject,handles)

mouse = handles.model.mouse;
chan = handles.model.chan;

[W, N, R, A] = loadWNRA(mouse);
if chan == 0
    LFP = loadEEGf(mouse);
    FR = zeros(1,43200);
elseif chan == -1
    Chns = handles.listbox_chan.String;
    nCh = length(Chns)-2;
    lfp = zeros(nCh, 48*60*60*256);
    fr = zeros(nCh, 43200);
    for i=1:nCh
        ch = str2num(Chns{i});
        lfp(i,:) = loadLFP(mouse, ch);
        fr(i,:) = loadFR(mouse, ch);
    end
    LFP = mean(lfp);
    FR = mean(fr);
else
    LFP = loadLFP(mouse, chan);
    FR = loadFR(mouse, chan);
end

SWA = slowwaveactivity(LFP, N&~A);
medSWA = medianBoutNREM(SWA, N, A);

handles.model.SWA = SWA;
handles.model.WNRA = vertcat(W,N,R,A);
handles.model.medSWA = medSWA;
handles.model.FR = FR;

handles.listbox_model.Enable = 'on';

plotModel(handles)
plotSavedS(handles)

busyLightOff(hObject,handles)

% Load Previously Saved Parameters
function pushbutton_loadparms_Callback(hObject, ~, handles)
mouse = handles.model.mouse;
chan = handles.model.chan;
modelType = handles.model.type;

parmfilename = [handles.savepath, mouse,'-ch',int2str(chan),'-m',int2str(modelType),'.mat'];
load(parmfilename, 'parms')
handles.model.parms = parms;

if modelType ==2
    handles.figureFRhist.Visible = 'on';
    plotFRhist(handles)
else
    handles.figureFRhist.Visible = 'off';
end

guidata(hObject,handles)
activateAdjParms(hObject,handles)
updateEditBoxes(hObject, handles)
calculateProcessS(hObject, handles)


% Button: Set Default Parameters
function pushbutton_default_Callback(hObject, ~, handles)
modelType = handles.model.type;

parms = [];
switch modelType
    case 1
	parms(1) = 0.00002; % Alpha
    parms(2) = 0.00008; % Beta
	parms(3) = 200;     % S0
    parms(4) = 0;
    parms(5) = 300;     % SWAmax
    parms(6) = 100;     % SWAmin
    case 2
	parms(1) = 4e-6; % Alpha
    parms(2) = 4e-5; % Beta
	parms(3) = 100;     % S0
    parms(4) = 20;      % FRthr
    parms(5) = 250;     % SWAmax
    parms(6) = 50;     % SWAmin
end
handles.model.parms = parms;

if modelType ==2
    handles.figureFRhist.Visible = 'on';
    plotFRhist(handles)
else
    handles.figureFRhist.Visible = 'off';
end

guidata(hObject,handles)
activateAdjParms(hObject,handles)
updateEditBoxes(hObject, handles)
calculateProcessS(hObject, handles)

% Button: Optimise Parameters
function pushbutton_optimise_Callback(hObject, ~, handles)
busyLightOn(hObject,handles)

modelType = handles.model.type;
FR = handles.model.FR;
medSWA = handles.model.medSWA;
N = handles.model.WNRA(2,:);
A = handles.model.WNRA(4,:);

switch modelType 
    case 1
    parms0 = [0.0001,0.0005,200,200,100];
    fun = @(x)optimiseFun_Classic(x, medSWA, N, A);
    opt.MaxFunEvals = 1000*5;
    opt.MaxIter = 1000*5;
    parms = fminsearch(fun, parms0, opt);
    parms = [parms(1:3),0,parms(4:5)];
    
    case 2
    try
        parms0 = handles.model.parms;
    catch
        parms0 = [4e-6,4e-5,100,21,300,50];
    end
    fun = @(x)optimiseFun_FR(x, FR, medSWA, N, A);
    opt.MaxFunEvals = 1000*6;
    opt.MaxIter = 1000*6;
    parms = fminsearch(fun, parms0, opt);  
end
handles.model.parms = parms;

if modelType == 2
    handles.figureFRhist.Visible = 'on';
    plotFRhist(handles)
else
    handles.figureFRhist.Visible = 'off';
end
busyLightOff(hObject,handles)
guidata(hObject,handles)
activateAdjParms(hObject,handles)
updateEditBoxes(hObject, handles)
calculateProcessS(hObject, handles)


% Button: Reset Plot
function pushbutton_resetplot_Callback(hObject, ~, handles)
plotModel(handles)
plotSavedS(handles)
plotAddS(handles)

% Button: Save Parameters
function pushbutton_save_Callback(hObject, ~, handles)
mouse = handles.model.mouse;
chan = handles.model.chan;
modelType = handles.model.type;
parms = handles.model.parms;
S = handles.model.S;
error = handles.model.error;
errorMetric = handles.model.errorMetric;

parmfilename = [handles.savepath, mouse,'-ch',int2str(chan),'-m',int2str(modelType),'.mat'];
save(parmfilename, 'parms', 'S', 'error', 'errorMetric')

% Button: Save Figure
function pushbutton_savefig_Callback(hObject, ~, handles)
mouse = handles.model.mouse;
chan = handles.model.chan;

fig = figure('Position', [100,100,1500,800], 'Visible','off');
ax = copyobj(handles.figure, fig);
set(ax(1),'Position',[30,10,250,45])
figfilename = [handles.savepath, mouse,'-ch',int2str(chan),'.jpg'];
saveas(fig, figfilename)


%--------------------------%
% Button: Increase Parameter 1
function pushbutton_p1inc_Callback(hObject, ~, handles)
changeParms(hObject, handles, 1, 1)

% Button: Decrease Parameter 1
function pushbutton_p1dec_Callback(hObject, ~, handles)
changeParms(hObject, handles, 1, 2)

% Edit: Parameter 1
function edit_p1_Callback(hObject, ~, handles)
changeParms(hObject, handles, 1, 3)

% Button: Increase Parameter 2
function pushbutton_p2inc_Callback(hObject, ~, handles)
changeParms(hObject, handles, 2, 1)

% Button: Decrease Parameter 2
function pushbutton_p2dec_Callback(hObject, ~, handles)
changeParms(hObject, handles, 2, 2)

% Edit: Parameter 2
function edit_p2_Callback(hObject, ~, handles)
changeParms(hObject, handles, 2, 3)

% Button: Increase Parameter 3
function pushbutton_p3inc_Callback(hObject, ~, handles)
changeParms(hObject, handles, 3, 1)

% Button: Decrease Parameter 3
function pushbutton_p3dec_Callback(hObject, ~, handles)
changeParms(hObject, handles, 3, 2)

% Edit: Parameter 3
function edit_p3_Callback(hObject, ~, handles)
changeParms(hObject, handles, 3, 3)

% Button: Increase Parameter 4
function pushbutton_p4inc_Callback(hObject, ~, handles)
changeParms(hObject, handles, 4, 1)

% Button: Decrease Parameter 4
function pushbutton_p4dec_Callback(hObject, ~, handles)
changeParms(hObject, handles, 4, 2)

% Edit: Parameter 4
function edit_p4_Callback(hObject, ~, handles)
changeParms(hObject, handles, 4, 3)

% Button: Increase Parameter 5
function pushbutton_p5inc_Callback(hObject, ~, handles)
changeParms(hObject, handles, 5, 1)

% Button: Decrease Parameter 5
function pushbutton_p5dec_Callback(hObject, ~, handles)
changeParms(hObject, handles, 5, 2)

% Edit: Parameter 5
function edit_p5_Callback(hObject, ~, handles)
changeParms(hObject, handles, 5, 3)

% Button: Increase Parameter 6
function pushbutton_p6inc_Callback(hObject, ~, handles)
changeParms(hObject, handles, 6, 1)

% Button: Decrease Parameter 6
function pushbutton_p6dec_Callback(hObject, ~, handles)
changeParms(hObject, handles, 6, 2)

% Edit: Parameter 6
function edit_p6_Callback(hObject, ~, handles)
changeParms(hObject, handles, 6, 3)

%------------------------------------------------------------------------%
% Model Functions
function calculateProcessS(hObject, handles)
modelType = handles.model.type;
FR = handles.model.FR;
Tmax = 43200;

switch modelType
    % Classic Model    
    case 1
        N = handles.model.WNRA(2,:);
        alpha = handles.model.parms(1);
        beta = handles.model.parms(2);
        S0 = handles.model.parms(3);
        Smax = handles.model.parms(5);
        Smin = handles.model.parms(6); 
        
        S = zeros(1,Tmax);
        S(1) = S0;
        for t=2:Tmax    
            if N(t)==0
                dSdt = alpha*(Smax - S(t-1)); 
            else 
                dSdt = beta*(Smin - S(t-1));
            end
            S(t) = S(t-1) + dSdt;
        end
    % Threshold Model    
    case 2
        alpha = handles.model.parms(1);
        beta = handles.model.parms(2);
        S0 = handles.model.parms(3);
        FRthr = handles.model.parms(4);
        Smax = handles.model.parms(5);
        Smin = handles.model.parms(6);        
        
        S = zeros(1,Tmax);
        S(1) = S0;
        for t=2:Tmax    
            if FR(t) > FRthr
                dSdt = alpha*(Smax - S(t-1))*(FR(t) - FRthr); 
            else 
                dSdt = beta*(Smin - S(t-1))*(FRthr - FR(t));
            end
            S(t) = S(t-1) + dSdt;
        end
end

% Error
medSWA = handles.model.medSWA;
WNRA = handles.model.WNRA;
N = handles.model.WNRA(2,:);
A = handles.model.WNRA(4,:);
[medProcS, durN] = medianBoutNREM(S, N, A);
durN(durN<=15) =[];
w = durN/sum(durN);
errorMetric = sum(abs(medSWA(:,2) - medProcS(:,2)) .*w');
error = median(abs(medSWA(:,2) - medProcS(:,2))./medSWA(:,2)) *100;

handles.model.S = S;
handles.model.error = error;
handles.model.errorMetric = errorMetric;
guidata(hObject,handles)
plotAddS(handles)


function plotModel(handles)
W = handles.model.WNRA(1,:);
N = handles.model.WNRA(2,:);
R = handles.model.WNRA(3,:);
FR = handles.model.FR;
cols = handles.modelcols;
SWA = handles.model.SWA;
medSWA = handles.model.medSWA;

axes(handles.figure)
cla
hold on
plot(FR, 'Color',[0.6,0.4,0.2]);
bar(medSWA(:,1),medSWA(:,2), 'k','barwidth',1);
bar(10*W,'FaceColor','g','EdgeColor','g')
bar(10*N,'FaceColor','b','EdgeColor','b')
bar(10*R,'FaceColor','r','EdgeColor','r')
xlabel('Time (hrs)')
ylabel('MUA (Hz), SWA (%mean), Process S')
set(gca,'XTick', 0:2700:43200)
set(gca,'XTickLabels', 0:3:48)
set(gca,'fontsize',18)
ylim([0,300])


function plotSavedS(handles)
mouse = handles.model.mouse;
chan = handles.model.chan;
cols = handles.modelcols;
for m=1:2
    try 
        parmfilename = [handles.savepath, mouse,'-ch',int2str(chan),'-m',int2str(m),'.mat'];
        load(parmfilename, 'S')
        plot(S,cols(m), 'LineWidth',1.5);
    catch
        continue
    end
end

function plotAddS(handles)
S = handles.model.S;
m = handles.model.type;
cols = handles.modelcols; 
axes(handles.figure)
plot(S,'Color',cols(m))


% Plot FR histograms
function plotFRhist(handles)
FR = handles.model.FR;
W = handles.model.WNRA(1,:);
N = handles.model.WNRA(2,:);
R = handles.model.WNRA(3,:);
FRthresh = handles.model.parms(4);

axes(handles.figureFRhist)
cla
hold on
histogram(FR(W), 'FaceColor', [0.85,0.4,0])
histogram(FR(N), 'FaceColor', [0.15,0.4,0.6])
histogram(FR(R), 'FaceColor', [0.35,0.15,0.5])
plot([FRthresh,FRthresh], [0,3000], 'k', 'Linewidth',1.5)
xlabel('Firing Rates (Hz)')
ylabel('Histogram Count')
legend({'Wake','NREM','REM'})


%------------------------------------------------------------------------%
% Misc Utils
function activateAdjParms(hObject,handles)
modelType = handles.model.type;

handles.edit_p1.Enable = 'on'; handles.pushbutton_p1dec.Enable = 'on';
handles.edit_p2.Enable = 'on'; handles.pushbutton_p2dec.Enable = 'on';
handles.edit_p3.Enable = 'on'; handles.pushbutton_p3dec.Enable = 'on';
handles.edit_p5.Enable = 'on'; handles.pushbutton_p5dec.Enable = 'on';
handles.edit_p6.Enable = 'on'; handles.pushbutton_p6dec.Enable = 'on';
handles.text_p1.Enable = 'on'; handles.pushbutton_p1inc.Enable = 'on';
handles.text_p2.Enable = 'on'; handles.pushbutton_p2inc.Enable = 'on';
handles.text_p3.Enable = 'on'; handles.pushbutton_p3inc.Enable = 'on';
handles.text_p5.Enable = 'on'; handles.pushbutton_p5inc.Enable = 'on';
handles.text_p6.Enable = 'on'; handles.pushbutton_p6inc.Enable = 'on';

if modelType == 1 
    handles.text_p4.Enable = 'off'; handles.pushbutton_p4inc.Enable = 'off';
    handles.edit_p4.Enable = 'off'; handles.pushbutton_p4dec.Enable = 'off';
elseif modelType == 2
    handles.text_p4.Enable = 'on'; handles.pushbutton_p4inc.Enable = 'on';
    handles.edit_p4.Enable = 'on'; handles.pushbutton_p4dec.Enable = 'on';
end

guidata(hObject,handles)


function updateEditBoxes(hObject, handles)
handles.edit_p1.String = num2str(handles.model.parms(1));
handles.edit_p2.String = num2str(handles.model.parms(2));
handles.edit_p3.String = num2str(handles.model.parms(3));
handles.edit_p5.String = num2str(handles.model.parms(5));
handles.edit_p6.String = num2str(handles.model.parms(6));
    
if handles.model.type==2
    handles.edit_p4.String = num2str(handles.model.parms(4));
    
end

guidata(hObject,handles)

function changeParms(hObject,handles, p, type)
switch type
    case 1
        handles.model.parms(p) = handles.model.parms(p) * 1.1;
    case 2
        handles.model.parms(p) = handles.model.parms(p) * 0.9;
    case 3
        prms(1) = str2double(handles.edit_p1.String);
        prms(2) = str2double(handles.edit_p2.String);
        prms(3) = str2double(handles.edit_p3.String);
        prms(4) = str2double(handles.edit_p4.String);
        prms(5) = str2double(handles.edit_p5.String);
        prms(6) = str2double(handles.edit_p6.String);
        handles.model.parms(p) = prms(p);
end

if handles.model.type == 2
    plotFRhist(handles)
end

guidata(hObject,handles)
updateEditBoxes(hObject, handles)
calculateProcessS(hObject, handles)

function busyLightOn(hObject,handles)
handles.BusyLight.BackgroundColor = 'r'; 
pause(0.1)
guidata(hObject,handles)

function busyLightOff(hObject,handles)
handles.BusyLight.BackgroundColor = [0.65,0.65,0.65]; 
guidata(hObject,handles)
